package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserAccountDayCashDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.service.UserAccountService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2019/3/4 13:58
 * @desc
 */
@Api(tags = "9-06 用户账户相关接口", description = "用户账户金额信息、金币信息、明细等")
@RestController
@RequestMapping("/api/user/account")
public class UserAccountController {

    @Autowired
    private UserAccountService userAccountService;

    @ApiOperation(value = "9-06-1 获取我的账户信息", httpMethod = "GET", notes = "获取用户对应的金币余额和现金余额、金币总收入、现金总收入")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("")
    public Json<UserAccountDTO> getUserAccount(@RequestParam("userId") Long userId) {
        return ResultUtil.genSuccessResult(this.userAccountService.getUserAccountAndEnableWithdraw(userId));
    }

    @ApiOperation(value = "9-06-2 获取用户账户信息和最近7天的现金收入", httpMethod = "GET", notes = "用户账户信息和统计用户对应每天的收入信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/cash")
    public Json<UserAccountDayCashDTO> getUserCashByDay(@RequestParam("userId") Long userId) {
        return ResultUtil.genSuccessResult(this.userAccountService.getUserAccountAndDetail(userId));
    }

    @ApiOperation(value = "9-06-3 获取个人中心钱包和金币信息", httpMethod = "GET", notes = "获取用户对应的金币余额和现金余额")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/my")
    public Json<UserCashGoldDTO> getUserCashGold(@RequestParam("userId") Long userId) {
        return ResultUtil.genSuccessResult(this.userAccountService.getUserCashGold(userId));
    }


    @ApiOperation(value = "9-06-4 用户提现弹窗上报", httpMethod = "POST", notes = "用户已经出现弹窗需要上报给服务端")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @PostMapping("/pop/withdraw")
    public Json userWithdrawPop(@RequestParam("userId") Long userId) {
        userAccountService.userWithdrawPop(userId);
        return ResultUtil.genSuccessMsg();
    }
}
