package com.bxm.localnews.user.controller;

import javax.annotation.Resource;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.service.UserRewardStatService;
import com.bxm.localnews.user.vo.GoldInfoModel;
import com.bxm.localnews.user.vo.MyGold;
import com.bxm.localnews.user.vo.UserAmount;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * Created by mars on 2018/3/6.
 */
@Api(tags = "9-03 用户账户相关接口", description = "用户账户金额信息、收入排行等")
@RestController
@RequestMapping()
public class UserAmountController {

    @Resource
    private UserAmountService userAmountService;

    @Resource
    private UserRewardStatService userRewardStatService;

    @ApiOperation("9-03-2 用户账户信息")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "api/amount/amountInfo", method = RequestMethod.POST)
    public Json<UserAmount> amountInfo(@RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult(this.userAmountService.findAmountByUserId(userId));
    }

    @ApiOperation(value = "9-03-3 我的金币界面", httpMethod = "POST", notes = "客户端请求获取的数据需要进行筛选---" + "金币大于0为收入，小于0为支出")
    @ApiImplicitParams({@ApiImplicitParam(name = "userId", value = "用户ID", required = true)})
    @PostMapping(value = "api/index/myGold")
    public Json<GoldInfoModel> myGold(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.myGoldStat(userId);
    }

    @Deprecated
    @ApiOperation(value = "9-03-4 我的昨日金币收益详情", httpMethod = "POST", notes = "")
    @ApiImplicitParams({@ApiImplicitParam(name = "userId", value = "用户ID", required = true)})
    @RequestMapping(value = "api/index/goldDetail", method = RequestMethod.POST)
    public Json<MyGold> goldDetail(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.myGoldDetail(userId);
    }
}
