/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.SmsJson;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.user.adapter.ParamAdapter;
import com.bxm.localnews.user.config.BizConfigProperties;
import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.PayToken;
import com.bxm.localnews.user.dto.RegisterMeta;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.WxUserInfo;
import com.bxm.localnews.user.integration.SmsIntegrationService;
import com.bxm.localnews.user.param.PushParam;
import com.bxm.localnews.user.param.SilentRegisterParam;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.param.UserParam;
import com.bxm.localnews.user.param.WechatBindParam;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.service.UserInternalService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.H5RegisterParam;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.config.AliyunOssProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-02 \u7528\u6237\u6ce8\u518c"}, description="\u7528\u6237\u6ce8\u518c\u548c\u7ba1\u7406")
@RestController
@RequestMapping(value={"api/user"})
@RefreshScope
public class UserController
extends BaseController {
    @Resource
    private UserService userService;
    @Resource
    private UserInternalService userInternalService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private SmsIntegrationService smsIntegrationService;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private UserProperties userProperties;
    @Resource
    private AliyunOssProperties aliyunOssProperties;
    @Resource
    private AliyunOSSService aliyunOSSService;
    @Resource
    private UserBaseInfoService userBaseInfoService;

    @ApiOperation(value="9-02-1 \u9759\u9ed8\u6ce8\u518c", notes="\u7528\u6237\u6253\u5f00app\uff0c\u4e0d\u5b58\u5728userId,\u6839\u636e\u8bbe\u5907\u53f7\u6765\u8fd4\u56de\u8be5\u624b\u673a\u6e38\u5ba2\u6a21\u5f0f\u7684userId")
    @ApiImplicitParams(value={@ApiImplicitParam(name="platform", value="\u5e73\u53f0\u4fe1\u606f 1\uff1a\u5b89\u5353 2\uff1aIOS 3\uff1aH5", allowableValues="1,2,3"), @ApiImplicitParam(name="chnl", value="\u6e20\u9053\u4fe1\u606f \u5177\u4f53\u67e5\u770bC_CHANNEL\u8868\u6216\u627e[\u8d75\u4e9a\u4e1c]"), @ApiImplicitParam(name="firstOpenType", value="\u662f\u5426\u662f\u7b2c\u4e00\u6b21\u6253\u5f00\u5e94\u7528\uff0c1\uff1a\u9996\u6b21\u6253\u5f00")})
    @RequestMapping(value={"toRegister"}, method={RequestMethod.POST})
    public Json<LoginMeta> register(SilentRegisterParam registerParam, BasicParam basicParam, String firstOpenType, HttpServletRequest request) {
        LoginInfo loginInfo = ParamAdapter.transformSilentRegisterToLoginInfo((SilentRegisterParam)registerParam);
        loginInfo.setRegIp(WebUtils.getIpAddr((HttpServletRequest)request));
        return this.userService.register(loginInfo, basicParam, firstOpenType);
    }

    @ApiOperation(value="9-02-2 \u666e\u901ah5\u9875\u9762\u6ce8\u518c", notes="\u53ea\u662f\u7b80\u5355\u7684\u63d0\u4f9b\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u5bc6\u7801\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="platform", value="\u5e73\u53f0\u4fe1\u606f 1\uff1a\u5b89\u5353 2\uff1aIOS 3\uff1aH5", allowableValues="1,2,3", required=true), @ApiImplicitParam(name="chnl", value="\u6e20\u9053\u4fe1\u606f \u5177\u4f53\u67e5\u770bC_CHANNEL\u8868\u6216\u627e[\u8d75\u4e9a\u4e1c]")})
    @RequestMapping(value={"/H5/toRegister"}, method={RequestMethod.POST})
    public Json<User> h5Register(H5RegisterParam registerParam, Integer platform, String chnl, HttpServletRequest request) {
        LoginInfo loginInfo = ParamAdapter.transformH5Register((H5RegisterParam)registerParam);
        loginInfo.setRegIp(WebUtils.getIpAddr((HttpServletRequest)request));
        return this.userService.doH5Register(loginInfo, platform, chnl);
    }

    @ApiOperation(value="9-02-3 \u91cd\u7f6e\u7528\u6237token", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="refreshToken", value="\u5237\u65b0\u7684token")})
    @RequestMapping(value={"refreshToken"}, method={RequestMethod.POST})
    public Json<UserInfoDTO> refreshToken(@RequestParam(value="userId") long userId, @RequestParam(value="refreshToken") String refreshToken) {
        return this.userService.refreshToken(Long.valueOf(userId), refreshToken);
    }

    @ApiOperation(value="9-02-4 \u83b7\u53d6\u7ed1\u5b9a\u624b\u673a\u53f7\u7801\u7684\u9a8c\u8bc1\u7801", notes="")
    @ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7")
    @PostMapping(value={"getBindPhoneCode"})
    public SmsJson getVerificationCode(String phone, HttpServletRequest httpServletRequest) {
        if (!Validater.checkPhone((String)phone)) {
            return SmsJson.build((Json)ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef"));
        }
        SmsSupplyDTO smsSupplyDTO = new SmsSupplyDTO();
        smsSupplyDTO.setPhoneNo(phone);
        smsSupplyDTO.setSmsTemplateEnum(SmsTemplateEnum.BINDING_PHONE);
        smsSupplyDTO.setIp(WebUtils.getIpAddr((HttpServletRequest)httpServletRequest));
        SendSmsResult result = this.smsIntegrationService.sendSmsByVCodeTemplate(smsSupplyDTO);
        int respCode = 0;
        respCode = result.getState() != false ? 0 : RespCode.BAD_REQUEST;
        return SmsJson.build((Json)ResultUtil.genFailedResult((int)respCode, (String)result.getMsg()));
    }

    @ApiOperation(value="9-02-5 \u9000\u51fa\u767b\u5f55", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @GetMapping(value={"logout"})
    public Json logout(Long userId) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="9-02-6 \u7ed1\u5b9a\u4e09\u65b9\u8d26\u53f7", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @RequestMapping(value={"bindingAccount"}, method={RequestMethod.POST})
    public Json<UserInfoDTO> binding(WechatBindParam wechatBindParam, Long userId) {
        LoginInfo loginInfo = ParamAdapter.transformWechatBindToLoginInfo((WechatBindParam)wechatBindParam);
        return this.userService.binding(loginInfo, userId);
    }

    @ApiOperation(value="9-02-10 \u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f", notes="\u5305\u542b \u5934\u50cf\u3001\u6635\u79f0\u3001\u6027\u522b\u3001\u751f\u65e5\u3001\u5730\u5740\u3001\u5174\u8da3")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @RequestMapping(value={"getUserBaseInfo"}, method={RequestMethod.GET})
    public Json<UserInfoDTO> getUserBaseInfo(@RequestParam(value="userId") long userId) {
        return ResultUtil.genSuccessResult((Object)this.userService.getUserFromRedisDB(userId));
    }

    @ApiOperation(value="9-02-11 \u66f4\u65b0\u7528\u6237\u4fe1\u606f", notes="\u76ee\u524d\u652f\u6301 \u6027\u522b\u3001\u751f\u65e5\u3001\u5730\u5740\u3001\u6635\u79f0\u3001\u5934\u50cf")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @RequestMapping(value={"updateUserInfo"}, method={RequestMethod.POST})
    public Json updateUserInfo(UserParam user) {
        Message message = this.userService.updateUserInfo(user, user.getUserId(), user.getFile());
        if (message.isSuccess()) {
            Map paramMap = message.getParamMap();
            UserInfoDTO userInfoDTO = (UserInfoDTO)paramMap.get("user");
            return ResultUtil.genSuccessResult((Object)userInfoDTO);
        }
        return Json.build((Message)message);
    }

    @ApiOperation(value="9-02-12 \u83b7\u53d6\u7528\u6237\u652f\u4ed8token", notes="\u83b7\u53d6\u7528\u6237\u7684\u652f\u4ed8token\uff0c\u6709\u6548\u671f\u4e3a\u4e00\u4e2a\u5c0f\u65f6")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @PostMapping(value={"getPayToken"})
    public Json<PayToken> getPayToken(Long userId) {
        String token = this.userService.getToken();
        return ResultUtil.genSuccessResult((Object)new PayToken(token));
    }

    @ApiOperation(value="9-02-13 \u83b7\u53d6\u7528\u6237\u63a8\u5e7f\u94fe\u63a5\uff08\u5305\u542b\u7528\u6237\u9080\u8bf7\u7801\uff09")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"getRegisterUrl"}, method={RequestMethod.POST})
    public Json<RegisterMeta> getRegisterUrl(Long userId) {
        String channelUrl = this.bizConfigProperties.getChannelUrl();
        return ResultUtil.genSuccessResult((Object)new RegisterMeta(channelUrl + userId));
    }

    @ApiOperation(value="9-02-14 \u83b7\u53d6\u4e2a\u4eba\u76f8\u5173\u4fe1\u606f", notes="\u5305\u542b\u59d3\u540d\u3001\u5934\u50cf\u3001\u91d1\u5e01\u3001\u7b7e\u5230\u4fe1\u606f\u3001\u9080\u8bf7\u4eba\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="platform", value="\u5e73\u53f0\u4fe1\u606f 1\uff1a\u5b89\u5353 2\uff1aIOS 3\uff1aH5", allowableValues="1,2,3", required=true)})
    @GetMapping(value={"getUserInfo"})
    public Json<UserBaseInfoDTO> getUserInfo(@RequestParam(value="userId") long userId, @RequestParam(value="platform") int platform) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="9-02-14 \u5b9a\u4f4d\u5f97\u5230\u57ce\u5e02\u5e76\u66f4\u65b0\u4f4d\u7f6e", notes="\u6839\u636e\u5ba2\u6237\u7aef\u4f20\u8fc7\u6765\u7684\u533a\u57df\u7f16\u53f7\u66f4\u65b0\u7528\u6237\u7684\u5730\u7406\u4f4d\u7f6e\uff0c\u5e76\u6dfb\u52a0\u7528\u6237\u5730\u7406\u4f4d\u7f6e\u5386\u53f2")
    @PostMapping(value={"/location"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID"), @ApiImplicitParam(name="code", value="\u5730\u533a\u7f16\u7801")})
    public Json<LocationDTO> getUserLocation(@RequestParam(value="userId", required=false) Long userId, @RequestParam(value="code", required=false) String code, BasicParam basicParam) {
        this.logger.debug("\u5f97\u5230\u57ce\u5e02code:{}", (Object)code);
        return ResultUtil.genSuccessResult((Object)this.userInternalService.doPostingLocation(code, userId, basicParam));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="9-02-15 \u83b7\u53d6\u7528\u6237\u5934\u50cf\u7684\u6587\u4ef6\u6d41", notes="\u4e0d\u518d\u63a8\u8350\u8c03\u7528\uff0c\u4fee\u6539\u4e3a9-2-18\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long")})
    @GetMapping(value={"/userInfo/img"})
    @Deprecated
    public void getPrivilegeImg(@RequestParam(name="userId") Long userId, HttpServletResponse response) throws IOException {
        BufferedInputStream dis = null;
        FilterOutputStream fos = null;
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId.longValue());
        if (userInfoDTO == null) {
            return;
        }
        String urlString = userInfoDTO.getHeadImg();
        if (StringUtils.isBlank((CharSequence)userInfoDTO.getHeadImg())) {
            return;
        }
        String fileName = urlString.substring(urlString.lastIndexOf(47) + 1);
        try {
            int bytesRead;
            URL url = new URL(urlString);
            response.reset();
            String contentType = FileTypeEnum.getContentType((String)urlString.substring(urlString.lastIndexOf(46) + 1));
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "image/jpeg";
            }
            response.setContentType(contentType);
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
            response.setHeader("Content-Length", String.valueOf(url.openConnection().getContentLength()));
            dis = new BufferedInputStream(url.openStream());
            fos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = dis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)fos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    @ApiOperation(value="9-02-16 \u83b7\u53d6\u624b\u673a\u53f7\u7801\u662f\u5426\u5df2\u6ce8\u518c", notes="")
    @GetMapping(value={"/userPhone"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7")})
    public Json<Boolean> isUserPhone(@RequestParam(value="phone") String phone, @RequestParam(value="flag", required=false, defaultValue="0") Integer flag) {
        return Json.build((Object)this.userService.checkUserExistByPhone(phone, flag));
    }

    @ApiOperation(value="9-02-17 \u4fdd\u5b58\u7528\u6237\u63a8\u9001\u4fe1\u606f", notes="\u6bcf\u4e2a\u7528\u6237\u4f1a\u4fdd\u5b58\u63a8\u9001\u7684\u5e73\u53f0\u4ee5\u53ca\u63a8\u9001\u7684token")
    @PostMapping(value={"/push"})
    public Json getPushToken(PushParam pushParam) {
        if (StringUtils.isEmpty((CharSequence)pushParam.getPushPlatform()) || StringUtils.isEmpty((CharSequence)pushParam.getPushToken()) || null == pushParam.getUserId()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        this.userInternalService.savePush(pushParam);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="9-02-18 \u83b7\u53d6\u7528\u6237\u5934\u50cf\u7684\u6587\u4ef6\u6d41", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long")})
    @GetMapping(value={"/userInfo/headimg"})
    public Json<String> getUserHeaderImg(@RequestParam(name="userId") Long userId) {
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId.longValue());
        if (userInfoDTO == null) {
            return Json.build((Object)this.userProperties.getDefaultHeadImgUrl());
        }
        String urlString = userInfoDTO.getHeadImg();
        if (StringUtils.isBlank((CharSequence)userInfoDTO.getHeadImg())) {
            return Json.build((Object)this.userProperties.getDefaultHeadImgUrl());
        }
        if (StringUtils.startsWith((CharSequence)urlString, (CharSequence)this.aliyunOssProperties.getCdnUrl())) {
            this.logger.debug("hit cache headimg:{}", (Object)userId);
            return Json.build((Object)urlString);
        }
        try {
            String fileExt = FileUtils.getFilextension((String)urlString);
            if (FileTypeEnum.getContentType((String)fileExt) == null) {
                fileExt = FileTypeEnum.JPG.getExtName();
            }
            URL url = new URL(urlString);
            BufferedInputStream dis = new BufferedInputStream(url.openStream());
            int hashCode = (int)(userId % 10L);
            String imgUrl = this.aliyunOSSService.upload((InputStream)dis, "avatar/" + hashCode + "/" + userId + "." + fileExt);
            userInfoDTO.setHeadImg(imgUrl);
            this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)userInfoDTO));
            return Json.build((Object)imgUrl);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u7528\u6237\u4fe1\u606f\u9519\u8bef");
        }
    }

    @ApiOperation(value="9-02-19 \u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f", notes="\u5305\u542b \u5934\u50cf\u3001\u6635\u79f0\u3001\u5730\u5740")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @RequestMapping(value={"getLocationUserInfo"}, method={RequestMethod.GET})
    public Json<LocationUserInfoDTO> getLocationUserInfo(@RequestParam(value="userId") long userId) {
        return ResultUtil.genSuccessResult((Object)this.userService.getLocationUserInfo(Long.valueOf(userId)));
    }

    @ApiOperation(value="9-02-20 \u521b\u5efa\u4e34\u65f6\u7528\u6237", notes="APP\u5206\u4eab\u65b0\u95fb\u3001\u6d3b\u52a8\u7b49\u9875\u9762\u901a\u8fc7\u9080\u8bf7\u9014\u5f84\u751f\u6210\u4e34\u65f6\u7528\u6237")
    @PostMapping(value={"/create/temp"})
    public Json<WxUserInfo> createTempUser(TempUserParam tempUserParam, HttpServletRequest request) {
        tempUserParam.setRegIp(WebUtils.getIpAddr((HttpServletRequest)request));
        Message message = this.userService.createUser(tempUserParam);
        return ResultUtil.genSuccessResult((Object)this.getWxUserInfo((long)((Long)message.getParamMap().get("userId")), tempUserParam));
    }

    private WxUserInfo getWxUserInfo(Long userId, TempUserParam tempUserParam) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        wxUserInfo.setUserId(userId);
        wxUserInfo.setHeadImg(tempUserParam.getHeadImg());
        wxUserInfo.setUnionId(tempUserParam.getUnionId());
        wxUserInfo.setNickname(tempUserParam.getNickName());
        return wxUserInfo;
    }
}

