package com.bxm.localnews.user.enums;

/**
 * 账号处理动作枚举类，所有可以对账号进行的操作动作都在这个枚举中进行定义
 * 每一个Action都有对应的Handler，详见servcie模块中的 com.bxm.localnews.user.account.impl.AccountHandlerProxy
 *
 * @author liujia
 * @date 2020/05/04 10:47
 */
public enum AccountActionEnum {
    //=================金币相关===========================
    // 可用金币： 可以消费、转让、提现的金币
    // 临时金币： 暂时还没得需求
    // 总金币： 至今获得过多少金币
    // 消费金币： 至今消耗了多少金币
    //=================金币相关===========================
    /**
     * 增加可用金币
     */
    ADD_USABLE_GOLD,

    /**
     * 增加临时金币
     */
    ADD_TEMP_GOLD,

    /**
     * 消费金币（扣除可用金币）
     */
    CONSUME_GOLD,

    //=================现金相关===========================
    // 临时金额：在一定的时间和条件下回过期的金额，有转化的条件限制，不最终变成可提现金额就没用
    // 永久金额：还是不能提现，但是在一定的业务条件下可用变成可提现金额
    // 提现金额：可以提现了
    // 提现中金额：等待运营后台审核的金额
    // 已提现金额：用户提走了的钱
    // 总金额：从用户账号流过的钱都算在里面，看起来就很多，很华丽，但是没卵用
    // 累计已结算： 用户总共在平台获得了多少可以提现的钱，包括不稳定的收入（购物未结算）
    // 购物未结算：在第三方结算周期之前，可以退单的商品返佣就是未结算
    // 购物已结算：第三方已结账，变成可提现金额
    // 开卡收益： 邀请别人开通VIP，给上级的返佣
    // 购物收益： 购物已结算、未结算的汇总
    // 其他收益： 在3.2.0版本之前做了很多和现金相关的活动，获得的收益都在其他
    //=================现金相关===========================

    /**
     * ======提现相关的账号动作 start ============
     * 可提现金额转提现中金额(发起提现)
     */
    DRAWABLE_TO_WITHDRAWAL,

    /**
     * 第三方回调或审核退还
     */
    FAIL_WITHDRAWAL,

    /**
     * 增加已提现金额（审核成功后）
     * ======提现相关的账号动作 end ============
     */
    ADD_WITHDRAWAL_CASH,

    /**
     * ======现金状态属性转化相关的账号动作 start ============
     * 临时金额转化为永久金额
     */
    TEMP_TO_STABILIZE,

    /**
     * 永久金额转化为可提现金额
     */
    STABILIZE_TO_DRAWABLE,

    /**
     * 临时赏金转化为可提现金额
     */
    TEMP_TO_DRAWABLE,

    /**
     * 将临时金额转化为失效金额
     * ======现金状态属性转化相关的账号动作 start ============
     */
    BOUNTY_INVALID,

    /**
     * 增加临时金额
     */
    ADD_TEMP_CASH,

    /**
     * 增加永久金额
     */
    ADD_STABILIZE_CASH,

    /**
     * 增加可提现金额
     */
    ADD_DRAWABLE_CASH,

    /**
     * 增加购物返佣
     */
    ADD_REBATE_CASH,

    /**
     * 购物返佣退还（用户取消订单）
     */
    SUB_REBATE_CASH,

    /**
     * 购物返佣结算(周期结算)
     */
    REBATE_SETTLE,

    /**
     * 增加省钱金额
     */
    ADD_SAVE_CASH
}
