package com.bxm.localnews.user.enums;

/**
 * 积分商城回调返回的状态值
 * @author zhaoyadong
 */
public enum DeductPointStatusEnum {

    SUCCESS("ok", "成功"),
    FAIL("fail", "失败");

    private String status;

    private String message;

    DeductPointStatusEnum(String status, String message) {
        this.status = status;
        this.message = message;
    }

    public static String getStatusByStatus(String status){
        for (DeductPointStatusEnum deductPointStatus : DeductPointStatusEnum.values()) {
            if (deductPointStatus.getStatus().equals(status)) {
                return deductPointStatus.getStatus();
            }
        }
        return null;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
