package com.bxm.localnews.user.domain;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.user.param.InviteRecordParam;
import com.bxm.localnews.user.vo.InviteRecord;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2019/3/5 19:50
 * @desc
 */
@Mapper
public interface InviteRecordMapper {

    /**
     * 获取对应用户的邀请信息
     *
     * @param userId
     * @param status
     * @return
     */
    List<InviteRecord> queryInviteRecords(@Param("userId") Long userId, @Param("status") Byte status);

    /**
     * 获取用户的邀请关系信息
     *
     * @param inviteRecordParam
     * @return
     */
    List<InviteRecord> queryUserInviteRecord(InviteRecordParam inviteRecordParam);

    /**
     * 添加邀请关系
     *
     * @param inviteRecord
     * @return
     */
    int addInviteRecord(InviteRecord inviteRecord);

    /**
     * 更新邀请关系金额
     *
     * @param inviteUserId
     * @param invitedUserId
     * @param cash
     * @return
     */
    Boolean updateInviteCash(@Param("userId") Long inviteUserId,
                             @Param("invitedUserId") Long invitedUserId, @Param("cash") BigDecimal cash);

    /**
     * 更新邀请关系
     *
     * @param inviteRecord
     * @return
     */
    int updateInviteRecord(InviteRecord inviteRecord);

    /**
     * @param inviteRecordParam
     * @return
     */
    InviteRecord getInviteRecordByUser(InviteRecordParam inviteRecordParam);

}
