package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "用户基本信息（万事通WST-version）")
public class UserBaseInfoDTO {

    @ApiModelProperty(value = "头像链接")
    private String headImg;

    @ApiModelProperty(value = "昵称")
    private String nickname;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "金币数")
    private Integer goldNum;

    @ApiModelProperty(value = "邀新人数")
    private Integer inviteNum;

    @ApiModelProperty(value = "签到信息")
    private SignWarper signWarper;

    @ApiModelProperty(value = "用户是否已完善资料")
    private boolean materialFinished;

    @ApiModelProperty(value = "消息通知数量")
    private Integer noticeNum;

    @ApiModelProperty(value = "通知红点显示，true显示/false不显示")
    private boolean redPoint;

    @ApiModelProperty(value = "我的发布")
    private Integer forumNum;

    public Integer getNoticeNum() {
        return noticeNum;
    }

    public void setNoticeNum(Integer noticeNum) {
        this.noticeNum = noticeNum;
    }

    public boolean isRedPoint() {
        return redPoint;
    }

    public void setRedPoint(boolean redPoint) {
        this.redPoint = redPoint;
    }

    public boolean isMaterialFinished() {
        return materialFinished;
    }

    public void setMaterialFinished(boolean materialFinished) {
        this.materialFinished = materialFinished;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getGoldNum() {
        return goldNum;
    }

    public void setGoldNum(Integer goldNum) {
        this.goldNum = goldNum;
    }

    public Integer getInviteNum() {
        return inviteNum;
    }

    public void setInviteNum(Integer inviteNum) {
        this.inviteNum = inviteNum;
    }

    public SignWarper getSignWarper() {
        return signWarper;
    }

    public void setSignWarper(SignWarper signWarper) {
        this.signWarper = signWarper;
    }

    public Integer getForumNum() {
        return forumNum;
    }

    public void setForumNum(Integer forumNum) {
        this.forumNum = forumNum;
    }
}
