package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.model.param.FollowListParam;
import com.bxm.localnews.user.param.UserFollowParam;
import com.bxm.localnews.user.param.UserIdFollowParam;
import com.bxm.localnews.user.vo.UserFollow;
import com.bxm.localnews.user.vo.UserFollowRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserFollowMapper {

    int insertFollowed(UserFollowRecord record);

    int updateFollowedStatus(UserFollowRecord record);

    UserFollowRecord getFollowedRecord(@Param("userId") Long userId, @Param("followedUserId") Long followedUserId);


    List<Long> getFollowedUserIdList(@Param("userId") Long userId);

    List<UserFollow> queryFollowByPage(UserFollowParam param);

    List<Long> getFollowedUserIds(UserIdFollowParam param);

    /**
     * 根据请求参数进行搜索 我关注的列表
     *
     * @param param 搜搜参数
     * @return 我关注的列表
     */
    List<UserFollow> searchFollow(FollowListParam param);
}

