package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.dto.*;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserInfoComplete;
import com.bxm.localnews.user.vo.UserLikeVo;
import com.bxm.newidea.component.vo.PageParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface UserMapper {

    /**
     * 插入用户数据库 慎用
     *
     * @param record
     * @return
     */
    int insertSelective(User record);

    /**
     * 根据用户id获得用户信息
     *
     * @param id
     * @return
     */
    User selectByPrimaryKey(Long id);

    /**
     * 更新用户的基本信息
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(User record);

    /**
     * 更新用户的地理位置信息
     *
     * @param record
     * @return
     */
    int updateLocationByPrimaryKeySelective(User record);

    User findByEquipment(@Param("equipment") String equipment);

    User findByPhone(@Param("phone") String phone);

    User findByWeixin(@Param("weixin") String weixin);

    User getUserByRefreshToken(@Param("userId") long userId, @Param("refreshtoken") String refreshtoken);

    User selectByUserId(@Param("userId") long userId);

    LocationUserInfoDTO getLocationUserInfo(@Param("userId") Long userId);

    int updateUserReceiveRedPacket(@Param("userId") Long userId);

    int updateUserToRisk(@Param("userId") Long userId);

    int addPostNum(@Param("userId") Long userId);

    int minusPostNum(@Param("userId") Long userId);

    int addReplyNum(@Param("userId") Long userId);

    int minusReplyNum(@Param("userId") Long userId);

    List<Long> selectUserGreaterThanUserId(Long userId);

    int updateUserLikeNumByUserId(UserLikeVo userLikeVo);

    int addAttentionNum(@Param("userId") Long userId, @Param("attentionCount") Integer attentionCount);

    int addFanNum(@Param("userId") Long userId, @Param("fanCount") Integer fanCount);

    List<Long> getLikeUserIdListByArea(@Param("areaCode") String areaCode);

    int updateBackgroundImgUrlById(@Param("id") Long id, @Param("backgroundImgUrl") String backgroundImgUrl);

    /**
     * 查询非马甲号用户的昵称，为了遍历是否有emoji表情
     *
     * @return
     */
    List<User> selectAllUsers();

    int updateLikeNumByUserId(Long userId);

    /**
     * 更新用户的昵称
     *
     * @param userId
     * @param nickname
     * @return
     */
    int updateUserNickname(@Param("id") Long userId, @Param("nickname") String nickname, @Param("isTempNickName") Byte isTempNickName, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的头像
     *
     * @param userId
     * @param headImg
     * @return
     */
    int updateUserHeadImg(@Param("id") Long userId, @Param("headImg") String headImg, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的生日
     *
     * @param userId
     * @param birthDay
     * @return
     */
    int updateUserBirth(@Param("id") Long userId, @Param("birthDay") Date birthDay, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的状态
     *
     * @param id     用户id
     * @param status 状态
     * @return
     */
    int updateUserStatus(@Param("id") Long id, @Param("status") byte status);

    /**
     * 更新用户的家乡
     *
     * @param userId
     * @param hometownCode
     * @return
     */
    int updateUserHometown(@Param("id") Long userId, @Param("hometownCode") String hometownCode, @Param("hometownName") String hometownName, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的情感
     *
     * @param userId
     * @param relationshipStatus
     * @return
     */
    int updateUserRelationshipStatus(@Param("id") Long userId, @Param("relationshipStatus") Byte relationshipStatus, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的职业
     *
     * @param userId
     * @return
     */
    int updateUserJob(@Param("id") Long userId,
                      @Param("jobType") Integer jobType,
                      @Param("jobTypeName") String jobTypeName,
                      @Param("jobCategoryName") String jobCategoryName,
                      @Param("jobCategory") Integer jobCategory,
                      @Param("company") String company,
                      @Param("jobTitle") String jobTitle, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的个人简介
     *
     * @param userId
     * @param personalProfile
     * @return
     */
    int updateUserPersonalProfile(@Param("id") Long userId, @Param("personalProfile") String personalProfile, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的手机号
     *
     * @param userId
     * @param phone
     * @return
     */
    int updateUserPhone(@Param("id") Long userId, @Param("phone") String phone, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的性别
     *
     * @param userId
     * @param sex
     * @return
     */
    int updateUserSex(@Param("id") Long userId, @Param("sex") Byte sex, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户的微信号
     *
     * @param userId
     * @param wechatId
     * @param infoCompleteState
     * @return
     */
    int updateUserWechat(@Param("id") Long userId, @Param("wechatId") String wechatId, @Param("infoCompleteState") Long infoCompleteState);

    /**
     * 更新用户新手引导资料
     *
     * @param user
     * @return
     */
    int updateNewbieGuideInfo(User user);

    /**
     * 批量获取用户列表
     *
     * @param ids
     * @return
     */
    List<User> listUserByIds(@Param("ids") List<Long> ids);

    /**
     * 更新用户完善资料程度
     *
     * @param userInfoComplete
     * @return
     */
    int updateUserInfoCompleteStatus(UserInfoComplete userInfoComplete);

    /**
     * 查找正常用户，更新用户个人资料完善度
     *
     * @return
     */
    List<User> queryPageByNormal(PageParam pageParam);

    /**
     * 查找正常用户的数量
     *
     * @return
     */
    double count();

    /**
     * 根据淘宝客 relation id 获取用户信息
     *
     * @param relationId
     * @return
     */
    UserTbkInfoBean selectUserByRelationId(@Param("relationId") String relationId);

    /**
     * 邀请徒弟数量自增
     *
     * @param userId 用户ID
     * @return 操作结果
     */
    int incrementInviteNum(Long userId);

    /**
     * 更新淘宝客绑定信息
     *
     * @param userId     userId
     * @param relationId relationId
     * @param specialId  specialId
     */
    void updateTbkInfo(@Param("userId") Long userId, @Param("relationId") String relationId,
                       @Param("specialId") String specialId);

    /**
     * 根据userId  获取用户淘宝客信息
     *
     * @param userId
     * @return
     */
    UserTbkInfoBean selectUserFromCacheByUserId(Long userId);

    /**
     * 查询用户信息
     *
     * @param userId : 用户id
     * @return 用户基本信息列表
     */
    List<UserBaseInfo> selectUserById(@Param("userId") Long userId);

    /**
     * 昵称模糊查询用户信息
     *
     * @param userName : 用户昵称
     * @return 用户基本信息列表
     */
    List<UserBaseInfo> selectUserByName(@Param("userName") String userName);

    /**
     * 根据地区获取评论排行 V3.3.0
     *
     * @param areaCode
     * @param limitNum
     * @return
     */
    List<InteractRankInfo> selectInteractRankInfo(@Param("areaCode") String areaCode, @Param("limitNum") int
            limitNum, @Param("userIds") List<Long> userIds);

    /**
     * 获取单个用户的评论数
     *
     * @param userId
     * @return
     */
    Integer getReplyNumById(@Param("userId") Long userId);

    /**
     * 获取用户信息列表，根据脱敏手机号码前缀和后缀
     *
     * @param phonePrefix 手机号码前缀（前三位）
     * @param phoneSuffix 手机号码后缀（后四位）
     * @return 用户信息列表
     */
    List<UserPhoneDTO> selectUserBySensitivePhone(@Param("phonePrefix") String phonePrefix,
                                                  @Param("phoneSuffix") String phoneSuffix);

    /**
     * 根据手机号码查询用户id信息
     *
     * @param phone 手机号码
     * @return
     */
    UserPhoneDTO selectUserByPhone(@Param("phone") String phone);

    /**
     * 查询areCode地区对应的用户数量
     *
     * @param areaCode 地区编码
     * @return 用户数
     */
    Long countByAreaCode(String areaCode);

    /**
     * 查询areCode地区对应的用户达人信息
     *
     * @param areaCode 地区编码
     * @return 用户数
     */
    List<User> getUserTalentInfoByAreaCode(@Param("areaCode") String areaCode);

    /**
     * 更新用户的温暖值（温暖值最小为0）
     *
     * @param userId    用户id
     * @param warmValue 温暖值
     * @return 结果
     */
    int updateUserWarmInfo(@Param("userId") Long userId, @Param("warmValue") Integer warmValue);
}
