package com.bxm.localnews.user.domain;


import com.bxm.localnews.user.model.entity.UserTalentInviteHistoryEntity;
import com.bxm.localnews.user.model.param.talent.GroupTalentListQueryParam;
import com.bxm.localnews.user.model.param.talent.IncreaseTalentDataParam;
import com.bxm.localnews.user.model.vo.talent.TalentGroupListVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

@Mapper
public interface UserTalentInviteHistoryMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserTalentInviteHistoryEntity record);

    int insertSelective(UserTalentInviteHistoryEntity record);

    UserTalentInviteHistoryEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserTalentInviteHistoryEntity record);

    int updateByPrimaryKey(UserTalentInviteHistoryEntity record);

    /**
     * 获取所有的下级达人（直接达人）
     *
     * @param inviteUserId 用户id
     * @return 所有直接达人
     */
    List<UserTalentInviteHistoryEntity> getTalentListByInviteUserId(@Param("inviteUserId") Long inviteUserId);

    /**
     * 获取所有的下级达人（间接达人）
     *
     * @param superUserId 用户id
     * @return 所有间接达人
     */
    List<UserTalentInviteHistoryEntity> getTalentListBySuperUserId(@Param("superUserId") Long superUserId);

    /**
     * 获取所有的下级达人数量（直接达人）
     *
     * @param inviteUserId 用户id
     * @return 所有直接达人
     */
    int countTalentByInviteUserId(@Param("inviteUserId") Long inviteUserId);

    /**
     * 获取所有的下级达人数量（间接达人）
     *
     * @param superUserId 用户id
     * @return 所有间接达人
     */
    int countTalentBySuperUserId(@Param("superUserId") Long superUserId);

    /**
     * 获取团队达人信息
     *
     * @param param 查询入参
     * @return 达人信息列表
     */
    List<TalentGroupListVO> getGroupTalentList(GroupTalentListQueryParam param);

    /**
     * 增加团队人数
     *
     * @param userId 用户id
     * @return 影响行数
     */
    int increaseGroupCount(@Param("userId") Long userId);

    /**
     * 通过用户id查询达人信息
     *
     * @param userId 用户id
     * @return 达人信息
     */
    UserTalentInviteHistoryEntity selectByUserId(Long userId);

    /**
     * 更新达人个人相关的统计数据
     *
     * @param increaseTalentDataParam 统计数据对象
     * @return 影响行数
     */
    int increaseTalentData(IncreaseTalentDataParam increaseTalentDataParam);

    /**
     * 增加达人团队相关的统计数据
     *
     * @param userId          用户id
     * @param groupProfile    团队收益
     * @param groupOrderCount 团队订单数
     * @return 影响行数
     */
    int increaseTalentGroupData(@Param("userId") Long userId,
                                @Param("groupProfile") BigDecimal groupProfile,
                                @Param("groupOrderCount") Integer groupOrderCount);

    /**
     * 获取所有下级达人（包含直接和间接）
     *
     * @param userId 达人用户id
     * @return 所有下级达人用户id集合
     */
    List<Long> getAllTalent(@Param("userId") Long userId);

}