package com.bxm.localnews.user.domain.activity;

import com.bxm.localnews.user.model.entity.UserAwardInviteBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface UserAwardInviteMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserAwardInviteBean record);

    UserAwardInviteBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserAwardInviteBean record);

    /**
     * 根据邀请人、被邀请人获取邀请记录
     *
     * @param inviteUserId 邀请人
     * @param userId       被邀请人
     * @return 邀请记录
     */
    UserAwardInviteBean selectByInviteUser(@Param("inviteUserId") Long inviteUserId, @Param("userId") Long userId);

    /**
     * 查询用户是否存在有效的邀请记录
     *
     * @param userId 用户ID
     * @param status 邀请记录状态
     * @return 邀请记录
     */
    UserAwardInviteBean selectByUserId(@Param("userId") Long userId, @Param("status") Integer status);
}