package com.bxm.localnews.user.domain.medal;


import com.bxm.localnews.user.model.entity.medal.UserMedalCounterInfoEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface UserMedalCounterInfoMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserMedalCounterInfoEntity record);

    int insertSelective(UserMedalCounterInfoEntity record);

    UserMedalCounterInfoEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserMedalCounterInfoEntity record);

    int updateByPrimaryKey(UserMedalCounterInfoEntity record);

    /**
     * 查询用户的勋章统计数据
     *
     * @param userId 用户id
     * @return 用户勋章统计数据
     */
    UserMedalCounterInfoEntity selectByUserId(@Param("userId") Long userId);

    /**
     * 改变统计数据数量
     *
     * @param userId       用户id
     * @param type         操作的类型
     * @param operatorType 操作类型0
     * @param operatorNum  操作的数量
     * @return 影响行数
     */
    int changeCount(@Param("userId") Long userId,
                    @Param("type") String type,
                    @Param("operatorType") Integer operatorType,
                    @Param("operatorNum") Integer operatorNum);

    /**
     * 替换用户连续签到天数
     *
     * @param userId    用户id
     * @param signCount 签到天数
     * @return 影响行数
     */
    int replaceSignCount(@Param("userId") Long userId,
                         @Param("signCount") Long signCount);
}