package com.bxm.localnews.user.domain.vip;

import com.bxm.localnews.user.vo.vip.UserActiveCodeBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface UserActiveCodeMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserActiveCodeBean record);

    UserActiveCodeBean selectByPrimaryKey(Long id);

    int updateByPrimaryKey(UserActiveCodeBean record);

    /**
     * 根据激活码获取唯一对应的激活码
     *
     * @param code 激活码
     * @return 激活码详情
     */
    UserActiveCodeBean selectByCode(String code);

    /**
     * 根据卡号获取激活码信息
     *
     * @param cardNo 卡号
     * @return 激活码详情
     */
    UserActiveCodeBean selectByCardNo(String cardNo);

    /**
     * 根据用户ID获取激活码信息，仅返回第一条
     *
     * @param userId 用户ID
     * @return 激活码详情
     */
    UserActiveCodeBean selectByUserId(@Param("userId") Long userId);

    /**
     * 更新激活码的使用词素
     *
     * @param record 激活码记录
     * @return 更新影响行数
     */
    int updateTimes(UserActiveCodeBean record);

    /**
     * 添加激活码使用次数
     *
     * @param record 激活码记录
     * @return 更新影响行数
     */
    int addTimes(UserActiveCodeBean record);

    /**
     * 更新激活码的所属用户
     *
     * @param record 激活码记录
     * @return 更新影响行数
     */
    int updateUserId(UserActiveCodeBean record);
}