package com.bxm.localnews.user.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "账号现金收益")
@Data
@Builder
public class AccountCashFlowDTO extends BaseBean {

    @Tolerate
    public AccountCashFlowDTO() {
    }

    @ApiModelProperty("现金收益流水ID")
    private Long id;

    @ApiModelProperty("收益金额，已格式化，使用字符串接收")
    @JsonFormat(pattern = "#0.00")
    private BigDecimal amount;

    @ApiModelProperty("流水收益备注（收益来源的描述）")
    private String remark;

    @ApiModelProperty("流水生成时间，已格式化，使用字符串接收")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    @ApiModelProperty("流水金额的正负符号，true为正数")
    private Boolean plus;
}
