package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(description = "用户账号现金收益数据")
@Data
@Builder
public class AccountIncomeDTO {
    @Tolerate
    public AccountIncomeDTO() {
    }

    @ApiModelProperty("累计预估收益金额")
    private BigDecimal estimateCash;

    @ApiModelProperty("累计已结算金额")
    private BigDecimal settledCash;

    @ApiModelProperty("未结算金额")
    private BigDecimal noSettlementCash;

    @ApiModelProperty("可提现(现金余额)金额")
    private BigDecimal drawablelCash;

    @ApiModelProperty("现金收益类型列表，用于渲染可以展示的列表")
    private List<AccountIncomeTypeDTO> incomeTypes;
}
