package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.SuperBuilder;

import java.util.List;

@ApiModel("本地人列表返回实体")
@Data
@SuperBuilder
public class NativeDTO {

    @ApiModelProperty("推荐类型， NORMAL：普通的本地人推荐  FILTER：筛选推荐 OTHER：其他推荐   备注：" +
            "NORMAL：平常在xx人栏目得到的列表 下拉、上划都传NORMAL" +
            "FILTER：点筛选之后得到的列表，（注意）有数据的情况：下拉、上划都传FILTER" +
            "OTHER：如果点筛选之后，没有命中数据，则会出现<其他推荐>栏目，这时候（注意） 下拉则传FILTER，上划则传OTHER " +
            "OUTER_FORUM: 站外本地人推荐")
    private String recommendCategory;

    @ApiModelProperty("推荐人列表详情")
    private List<NativeInfoDTO> nativeInfoList;

}
