package com.bxm.localnews.user.dto;

import com.bxm.localnews.user.dto.warmlevel.OneselfHomePageCoverDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "主态个人主页相关信息")
@Data
public class OneselfHomePageDTO extends BaseHomePage {

	@ApiModelProperty(value = "所有访问数量")
	private Integer allInterviewNum;

	@ApiModelProperty(value = "今日访问数量")
	private Integer todayInterviewNum;

	@ApiModelProperty(value = "最近访问用户头像")
	private List<String> interviewHeadImgs;

	@ApiModelProperty("是否是vip：0-不是 1-是")
	private Integer isVip;

	@ApiModelProperty("是否认证商家 0 否  1 是")
	private Integer merchantStatus;

	@ApiModelProperty("认证商家id")
	private Long merchantId;

    @ApiModelProperty("认证商家名称")
    private String merchantName;

    @ApiModelProperty("更换封面信息")
    private OneselfHomePageCoverDTO coverDTO;

}
