package com.bxm.localnews.user.dto;

import com.bxm.localnews.user.dto.officialAccount.UserEarningsDTO;
import com.bxm.localnews.user.model.UserEquityDTO;
import com.bxm.localnews.user.model.dto.medal.UserMedalDTO;
import com.bxm.localnews.user.vo.GoldTodayInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(description = "用户基本信息（万事通WST-version）")
@Data
public class UserBaseInfoDTO {

    @ApiModelProperty(value = "头像链接")
    private String headImg;

    @ApiModelProperty(value = "昵称")
    private String nickname;

    @ApiModelProperty("用户性别：0:未知; 1:男; 2:女")
    private Byte sex;

    @ApiModelProperty(value = "红花数量")
    private Integer goldNum;

    @ApiModelProperty(value = "我的发布数量")
    private Integer forumNum;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty(value = "关注数量")
    private Integer attentionNum;

    @ApiModelProperty(value = "粉丝数量")
    private Integer fanNum;

    @ApiModelProperty(value = "粉丝数量右上角未读小红点")
    private Long unReadFanNum;

    @ApiModelProperty(value = "所有访问数量")
    private Integer allInterviewNum;

    @ApiModelProperty(value = "今日访问数量")
    private Integer todayInterviewNum;

    @ApiModelProperty(value = "手机号", hidden = true)
    @Deprecated
    private String phone;

    @ApiModelProperty(value = "邀请（徒弟）人数")
    private Integer inviteNum;

    @ApiModelProperty(value = "签到信息", hidden = true)
    @Deprecated
    private SignWarper signWarper;

    @ApiModelProperty(value = "用户是否已完善资料", hidden = true)
    @Deprecated
    private Boolean materialFinished;

    @ApiModelProperty(value = "消息通知数量", hidden = true)
    @Deprecated
    private Integer noticeNum;

    @ApiModelProperty(value = "通知红点显示，true显示/false不显示", hidden = true)
    @Deprecated
    private Boolean redPoint;

    @ApiModelProperty(value = "用户账户信息（包括用户现金余额、金币余额）")
    private UserCashGoldDTO userCashGoldDTO;

    @ApiModelProperty("是否是vip：0-不是 1-是")
    private Integer isVip;

    @ApiModelProperty("剩余开卡次数")
    private Integer leftOpenNum;

    @ApiModelProperty("VIP卡号")
    private String cardNo;

    @ApiModelProperty("VIP激活邀请码")
    private String activeCode;

    @ApiModelProperty("有效截止日期：yyyy-MM-dd")
    private String endDate;

    @ApiModelProperty("邀请的徒弟的头像地址列表，用于在个人中心显示")
    private List<String> inviteUserHeadImgList;

    @ApiModelProperty("订单隐私状态 true: 开启 false: 关闭")
    private Boolean orderPrivacy;

    @ApiModelProperty("是否认证商家 0 否  1 是")
    private Integer merchantStatus;

    @ApiModelProperty("认证商家id")
    private Long merchantId;

    @ApiModelProperty("认证商家名称")
    private String merchantName;

    @ApiModelProperty("3.10.0需求 今日红花收益")
    private GoldTodayInfo goldTodayInfo;

    @ApiModelProperty("达人等级：0普通用户，1小达人，2中达人，3大达人")
    private Integer talentLevel;

    @ApiModelProperty("用户收益相关信息")
    private UserEarningsDTO userEarnings;

    @ApiModelProperty("用户勋章相关信息")
    private UserMedalDTO userMedalDTO;

    @ApiModelProperty("3.12.0用户权益等级信息")
    private UserEquityDTO equityDTO;
}
