package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(description = "用户个人中心账户和金币")
@Data
public class UserCashGoldDTO {

    @ApiModelProperty("我的钱包 - 累计总金额")
    private BigDecimal cash;

    @ApiModelProperty("我的钱包 - 累计总金额，格式化字符串显示（eg:9.12K元）")
    private String cashFormat;

    @ApiModelProperty("我的金币 - 可用金币")
    private Integer gold;

    @ApiModelProperty("可用金币对应的提现金额")
    private BigDecimal convertCash;

    @ApiModelProperty("累计金币")
    private Integer totalGold;

    public UserCashGoldDTO() {
    }

    public UserCashGoldDTO(BigDecimal cash, Integer gold) {
        this.cash = cash;
        this.gold = gold;
    }

    public UserCashGoldDTO(BigDecimal cash, Integer gold, BigDecimal convertCash, Integer totalGold) {
        this.cash = cash;
        this.gold = gold;
        this.convertCash = convertCash;
        this.totalGold = totalGold;
    }
}
