package com.bxm.localnews.user.dto;

import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 用户徒弟统计对象，直接返回页面需要的全部相关数据
 *
 * @author liujia
 * @date 2020/05/03 16:02
 */
@ApiModel(description = "用户邀请徒弟的汇总信息")
@Data
public class UserInviteCollectDTO {

    @ApiModelProperty("总共邀请人数")
    private Integer total;

    @ApiModelProperty("今日邀请人数")
    private Integer todayTotal;

    @ApiModelProperty("昨日邀请人数")
    private Integer yesterdayTotal;

    @ApiModelProperty("一级徒弟人数")
    private Integer oneLevel;

    @ApiModelProperty("二级徒弟人数")
    private Integer twoLevel;

    @ApiModelProperty("潜在徒弟人数（建立邀请关系，但未登陆APP）")
    private Integer nonActivated;

    @ApiModelProperty("第一页数据，上拉分页需要调用分页接口获取")
    private PageWarper<UserInviteDTO> firstPage;
}
