package com.bxm.localnews.user.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@Builder
public class UserPersonalInfoDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("性别")
    private Byte sex;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("生日(精确到日)")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT_YEAR_MONTH_DAY_FORMAT)
    private Date birthday;

    @ApiModelProperty(value = "用户是否使用的临时昵称 ps：0代表不能修改昵称了")
    private Byte isTempNickName;

    @ApiModelProperty("行业（显示在个人资料栏目）")
    private String industry;

    @ApiModelProperty("行业详情")
    private IndustryInfo industryInfo;

    @ApiModelProperty(value = "兴趣爱好标签列表")
    private List<String> userTagList;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty(value = "是否默认个人简介 true 默认 false 不是默认")
    private Boolean isDefaultPersonalProfile;

    @ApiModelProperty(value = "情感状态 0：保密  1：单身  2：恋爱中  3：已婚")
    private Byte relationshipStatus;

    @ApiModelProperty(value = "家乡地区编码")
    private String hometownCode;

    @ApiModelProperty(value = "家乡名称")
    private String hometownName;

    @ApiModelProperty("年龄段 如：90后")
    private String generation;

    @ApiModelProperty("微信号，1，微信号的填写规则：\n" +
            "-可使用6-20个字母，数字，下划线和减号\n" +
            "-不支持设置中文\n" +
            "2，如果用户输入了表情和中文以及其他特殊符号，点击保存时，提示“请不要输入中文和其他特殊符号”")
    private String wechatId;

    @ApiModelProperty("资料完善百分比，如60")
    private Integer infoCompletePercent;

    @ApiModelProperty("首次完成资料奖励文案")
    private String infoCompleteTaskText;

    @ApiModelProperty("用户是否已完成新手引导,返回1则表示已完成")
    private Byte newbieGuideFlag;

    @Builder
    public static class IndustryInfo {
        @ApiModelProperty("行业一级id")
        private Integer jobType;

        @ApiModelProperty("行业一级名称")
        private String jobTypeName;

        @ApiModelProperty("行业二级名称")
        private String jobCategoryName;

        @ApiModelProperty("行业二级id")
        private Integer jobCategory;

        @ApiModelProperty("公司")
        private String company;

        @ApiModelProperty("职业")
        private String jobTitle;

        public Integer getJobType() {
            return jobType;
        }

        public void setJobType(Integer jobType) {
            this.jobType = jobType;
        }

        public String getJobTypeName() {
            return jobTypeName;
        }

        public void setJobTypeName(String jobTypeName) {
            this.jobTypeName = jobTypeName;
        }

        public String getJobCategoryName() {
            return jobCategoryName;
        }

        public void setJobCategoryName(String jobCategoryName) {
            this.jobCategoryName = jobCategoryName;
        }

        public Integer getJobCategory() {
            return jobCategory;
        }

        public void setJobCategory(Integer jobCategory) {
            this.jobCategory = jobCategory;
        }

        public String getCompany() {
            return company;
        }

        public void setCompany(String company) {
            this.company = company;
        }

        public String getJobTitle() {
            return jobTitle;
        }

        public void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }
    }

}
