package com.bxm.localnews.user.dto.auth;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.List;

@ApiModel(description = "用户鉴权相关信息")
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class UserAuthCodeDto extends BaseBean {

    @Tolerate
    public UserAuthCodeDto() {
    }

    @ApiModelProperty(value = "用户持有的权限编码数组")
    private Long[] combineAuthCode;

    @ApiModelProperty(value = "用户持有的权限数据资源列表")
    private List<UserAuthResourceDto> authResources;
}
