package com.bxm.localnews.user.dto.officialAccount;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2020/12/21 9:57
 */
@ApiModel("用户收益信息")
@Data
public class UserEarningsDTO {

    @ApiModelProperty("累计收入(普通用户的--我的收益---达人的-全部收益)")
    private BigDecimal totalCash;

    @ApiModelProperty("直卖收益")
    private BigDecimal directSellEarnings;

    @ApiModelProperty("团队收益")
    private BigDecimal teamEarnings;

    @ApiModelProperty("待升级收益，中达人特有")
    private BigDecimal waitUpgradeEarnings;

    @ApiModelProperty("可提现金额")
    private BigDecimal drawableCash;

    @ApiModelProperty("已提现金额")
    private BigDecimal withdrawalCash;

    @ApiModelProperty("未结算金额")
    private BigDecimal noSettlementCash;
}
