package com.bxm.localnews.user.param;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.PageParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "分页查询用户现金流水")
@Data
public class AccountCashFlowPageParam extends PageParam implements IUserIdSharding {
    @ApiModelProperty(value = "现金流水编码，通过接口：9-07-2获取", required = true)
    private String cashFlowCode;

    @ApiModelProperty(value = "查询的用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "查询的具体流水类型", hidden = true)
    @JsonIgnore
    private List<String> includeTypeList;

    @ApiModelProperty(value = "排除的具体流水类型", hidden = true)
    @JsonIgnore
    private List<String> excludeTypeList;

    @ApiModelProperty(value = "3.11.0收入流水类型 1 收入 2 支出", hidden = true)
    @JsonIgnore
    private Integer incomeType;
}
