package com.bxm.localnews.user.param;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author Gonzo
 * @date 2019-11-20 10:59
 */
@Data
@ApiModel(description = "赠送小红花请求参数")
public class TransformParam extends BasicParam {

    @ApiModelProperty(value = "赠送发起人id",required = true)
    @NotNull
    private Long userId;

    @ApiModelProperty(value = "被赠送人id",required = true)
    @NotNull
    private Long targetUserId;

    @ApiModelProperty(value = "赠送的数量 eg: 100", example = "100",required = true)
    @NotNull
    private Integer num;

    @ApiModelProperty(value = "赠送类型 1：互动赠送小红花", example = "1",required = true)
    @NotNull
    private Byte type;

    @ApiModelProperty(value = "赠送时间",required = true)
    @NotNull
    private Date presentTime;

    private String areaCode;

}
