package com.bxm.localnews.user.param;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.multipart.MultipartFile;

@ApiModel(description = "用户实体入参")
public class UserParam {

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户昵称 只能改一次")
    private String nickname;

    @ApiModelProperty("性别：0:保密；1:男 ;2:女")
    private Byte sex;

    @ApiModelProperty("生日(精确到日) 格式：yyyy-mm-dd")
    private Date birthday;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("头像图片")
    private MultipartFile file;

    @ApiModelProperty("头像地址")
    private String headImg;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Byte getSex() {
        return sex;
    }

    public void setSex(Byte sex) {
        this.sex = sex;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public MultipartFile getFile() {
        return file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPersonalProfile() {
        return personalProfile;
    }

    public void setPersonalProfile(String personalProfile) {
        this.personalProfile = personalProfile;
    }
}
