/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Objects;

/**
 * @author : jieli.xu
 * @date 2020/6/18 9:52
 * 用户栏目列表
 */
@Data
@ApiModel("用户栏目列表")
public class UserChannelVO implements Comparable<UserChannelVO> {


    @ApiModelProperty("栏目id")
    private Long id;
    @ApiModelProperty("栏目名称")
    private String channelName;
    @ApiModelProperty("渠道连接地址/或者是协议 ，可能有通配符")
    private String channelUrl;
    @ApiModelProperty("排序：小的靠前")
    private Integer sort;
    @ApiModelProperty("是否固定[不可编辑]：0：否 1：是")
    private Integer isFixed = 0;
    @ApiModelProperty("默认关注0:false 1true")
    private Integer focusOn = 0;

    /**
     * 是否默认选择的tab，如果是，则默认选择当前tab展示 0：否 1：是
     */
    private Byte defaultChose;
    /**
     * 区域类型 1：反选（不包括） 2： 选择
     */
    private Integer areaType;
    /**
     * 区域编码
     */
    private String code;
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 栏目图标
     */
    private String channelIcon;

    /**
     * 重写equals比较方法，用于list.constants() 使用
     *
     * @param o
     * @return
     */
    @Override
    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        UserChannelVO that = (UserChannelVO) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), id);
    }

    /**
     * 重写排序方法 ： isFixed 大的排前面 ，sort 小的排前面
     *
     * @param o
     * @return
     */
    @Override
    public int compareTo(UserChannelVO o) {
        int fixedSort = o.isFixed.compareTo(isFixed);
        if (fixedSort != 0) {
            return fixedSort;
        }
        return sort.compareTo(o.sort);
    }
}
