package com.bxm.localnews.user.vo;

import com.bxm.localnews.user.model.UserWarmLevelDTO;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户关注实体")
@Data
public class UserFollow extends BaseBean {

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("是否是vip：0-不是 1-是")
    private Integer isVip;

    @ApiModelProperty("用户性别：0:未知; 1:男; 2:女")
    private Byte sex;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty("关注状态：0已关注 1未关注 2互相关注")
    private Byte status;

    @ApiModelProperty("3.12.0 用户温暖值等级信息")
    private UserWarmLevelDTO userWarmLevelDTO;

}