package com.bxm.localnews.user.vo;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public class UserFunsRecord extends BaseBean implements IUserIdSharding {

    private Long id;

    /**
     * 关注记录所属用户
     */
    private Long userId;

    /**
     * 用户的粉丝ID
     */
    private Long funsUserId;

    /**
     * 关注类型
     * 0:未关注
     * 1：已关注
     * 2：相互关注
     */
    private Byte type;

    public UserFunsRecord() {
    }

    public UserFunsRecord(Long userId, Long funsUserId) {
        this.userId = userId;
        this.funsUserId = funsUserId;
    }
}