package com.bxm.localnews.user.vo;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * t_wx_official_account
 *
 * @author
 */
@Data
@ApiModel("微信公众号关注表")
@Builder
public class WxOfficialAccount implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 微信关联的uid
     */
    private String wxUid;

    @Deprecated
    private Long userId;

    /**
     * 微信关联公众号的openid
     */
    private String wxOid;

    /**
     * 微信公众号number
     */
    private String officialAccountNumber;

    /**
     * 公众号关注状态 0-未关注,1-已关注
     */
    private Integer focusStatus;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    private static final long serialVersionUID = 1L;

    @Tolerate
    public WxOfficialAccount() {

    }
}