package com.bxm.localnews.user.domain;


import com.bxm.localnews.user.vo.LocationRelationUser;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


@Mapper
public interface LocationRelationChannelMapper {


    /**
     * 获取用户个人列表的表数据
     * @param userId
     * @param code
     * @return
     */
    List<LocationRelationUser> getListByUidCode(@Param("userId")Long userId,@Param("code")String code);
    /**
     * 新增插入关联关系
     * @param locationRelationUser
     * @return
     */
    int insert(LocationRelationUser locationRelationUser);

    /**
     * 新增插入关联关系:批量插入
     * @param locationRelationUser
     * @return
     */
    int batchInsert(@Param("list") List<LocationRelationUser> locationRelationUser);

    /**
     * 修改状态或者排序
     * @return
     */
    int updateByUidCode(LocationRelationUser locationRelationUser);

    /**
     * 除过这些id，其余的更新状态为0
     * @param userId : 用户id
     * @param code ： 区域编码
     * @param channelIds ： 需要更新的channelId
     * @return ： 更新的数量
     */
    int batchUpdateStatus(@Param("userId")Long userId,@Param("code")String code,@Param("channelIds") List<Long> channelIds);

    /**
     * 真删除个人列表的表数据
     * @param userId
     * @param code
     * @return
     */
    Boolean deleteByUidCode(@Param("userId")Long userId,@Param("code")String code);
}