package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.vo.UserLoginHistory;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface UserLoginHistoryMapper {

    int insertSelective(UserLoginHistory record);

    List<UserLoginHistory> selectUserByEquipment(@Param("userId") Long userId, @Param("equipment") String equipment);

    List<UserLoginHistory> selectByEquipment(String equipment);

    Date selectMinLoginTime(Long userId);

    /**
     * 获取第一条or最后一条
     * @param userId userId
     * @param type 0第一条 1最后一条
     * @return 登录历史
     */
    UserLoginHistory selectFirstOrLastOne(@Param("userId") Long userId, @Param("type") int type);
}