package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.model.vo.UserStatisticsBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface UserStatisticsMapper {

    int countRegUser(@Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 时间段内的注册用户
     *
     * @param startTime 开始时间
     * @param endTime   截止时间
     * @return 注册用户统计信息
     */
    List<UserStatisticsBean> regUser(@Param("startTime") Date startTime, @Param("endTime") Date endTime);

    /**
     * 时间段内激活的VIP信息
     *
     * @param startTime 开始时间
     * @param endTime   截止时间
     * @return VIP用户统计信息
     */
    List<UserStatisticsBean> vipUser(@Param("startTime") Date startTime, @Param("endTime") Date endTime);
}
