package com.bxm.localnews.user.domain.vip;

import com.bxm.localnews.user.vo.vip.UserActiveRelationBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserActiveRelationMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserActiveRelationBean record);

    int insertSelective(UserActiveRelationBean record);

    UserActiveRelationBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserActiveRelationBean record);

    int updateByPrimaryKey(UserActiveRelationBean record);

    /**
     * 根据激活码查询对应的激活人数
     *
     * @param activeCode 激活码
     * @return 使用了激活码的人员
     */
    List<UserActiveRelationBean> selectByCode(String activeCode);

    /**
     * 删除激活码的使用记录
     *
     * @param activeCode 激活码
     * @param userId     用户ID
     * @return 影响行数
     */
    int removeRelation(@Param("activeCode") String activeCode, @Param("userId") Long userId);
}