package com.bxm.localnews.user.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * 现金收益类型，用于排班
 *
 * @author liujia
 * @date 2020/05/07 17:23
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "现金收益类型，用于动态控制显示的类型")
@Data
@Builder
public class AccountIncomeTypeDTO extends BaseBean {
    @Tolerate
    public AccountIncomeTypeDTO() {
    }

    @ApiModelProperty("现金流水标签，包括：全部、购物收益、开卡佣金、其他佣金等")
    private String cashFlowLabel;

    @ApiModelProperty("现金流水编码，查询流水时作为参数")
    private String cashFlowCode;

    @ApiModelProperty("当前收益类型在账号中的金额")
    private BigDecimal amount;

    @ApiModelProperty("当前收益类型是否显示订单，true则显示")
    private Boolean showOrder;

    @ApiModelProperty("当前收益类型是否显示VIP引导")
    private Boolean showGuide;
}
