package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.SuperBuilder;

import java.util.List;
@ApiModel("本地人返回基础信息实体")
@SuperBuilder
@Data
public class NativeBaseInfoDTO {
    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("头像")
    private String headImg;

    @ApiModelProperty("距离 如：1公里以内")
    private String distance;

    @ApiModelProperty("性别 0：未知 1：男 2：女")
    private Byte sex;

    @ApiModelProperty("年龄段 如：90后")
    private String generation;

    @ApiModelProperty("行业标签")
    private String industry;

    @ApiModelProperty("兴趣爱好标签列表")
    private List<String> hobbyList;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty(value = "图片列表,旧，标记不用", hidden = true)
    private List<ImgDTO> imgList;

    @ApiModelProperty("推荐人类型，显示在用户右上角的标签  0:附近的人 1:本地人 2:完善资料引导")
    private Byte recommendType;
}
