package com.bxm.localnews.user.dto;

import com.bxm.localnews.user.dto.auth.UserAuthResourceDto;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2018/2/23.
 * 用户信息
 */
@ApiModel(description = "用户实体返回包装类")
@Data
public class UserInfoDTO {

    /**
     * 用户实体的版本信息
     * 用于控制缓存是否需要更新，避免直接删除整个缓存导致缓存穿透
     * 当缓存中加载的"v"不等于"CURRENT_VERSION"，说明需要重新加载用户的缓存
     */
    public static final int CURRENT_VERSION = 3;

    /**
     * 设置初始值，缓存回写时会被覆盖
     */
    @ApiModelProperty(value = "当前对象的版本", hidden = true)
    private int v = CURRENT_VERSION;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("性别")
    private Byte sex;

    @ApiModelProperty("用户访问凭证")
    private String token;

    @ApiModelProperty("微信")
    private String weixin;

    @ApiModelProperty("状态")
    private Byte state;

    @ApiModelProperty("手机号")
    private String phone;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    @ApiModelProperty("生日(精确到日)")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT_YEAR_MONTH_DAY_FORMAT)
    private Date birthday;

    @ApiModelProperty(value = "用户是否使用的临时昵称 ps：0代表不能修改昵称了")
    private Byte isTempNickName;

    @ApiModelProperty("注册来源")
    private String registerChannel;

    @ApiModelProperty(value = "注册关联id")
    private Long relationId;

    @ApiModelProperty(value = "邀请人id")
    private Long inviteUserId;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty(value = "关注数量")
    private Integer attentionNum;

    @ApiModelProperty(value = "粉丝数量")
    private Integer fanNum;

    @ApiModelProperty(value = "点赞数量")
    private Integer likeNum;

    @ApiModelProperty(value = "发帖数量")
    private Integer postNum;

    @ApiModelProperty(value = "背景图")
    private String backgroundImgUrl;

    @ApiModelProperty(value = "是否默认个人简介 true 默认 false 不是默认")
    private Boolean isDefaultPersonalProfile;

    @ApiModelProperty("行业标签")
    private String industry;

    @ApiModelProperty("行业一级id")
    private Integer jobType;

    @ApiModelProperty("行业一级名称")
    private String jobTypeName;

    @ApiModelProperty("行业二级名称")
    private String jobCategoryName;

    @ApiModelProperty("行业二级id")
    private Integer jobCategory;

    @ApiModelProperty("公司")
    private String company;

    @ApiModelProperty("职业")
    private String jobTitle;

    @ApiModelProperty(value = "情感状态 0：保密  1：单身  2：恋爱中  3：已婚")
    private Byte relationshipStatus;

    @ApiModelProperty(value = "家乡地区编码")
    private String hometownCode;

    @ApiModelProperty(value = "家乡名称")
    private String hometownName;

    @ApiModelProperty(value = "当前地区编码")
    private String locationCode;

    @ApiModelProperty(value = "当前地区名称")
    private String locationName;

    @ApiModelProperty(value = "当前地区名称-简称 历史遗留原因 locationName存在库内是简称，但对象转换是转成了fullName，所以定义这个字段为简称")
    private String locationShortName;

    @ApiModelProperty(value = "用户持有的权限编码数组")
    private Long[] combineAuthCode;

    @ApiModelProperty(value = "用户持有的权限数据资源列表")
    private List<UserAuthResourceDto> authResources;

    @ApiModelProperty("用户资料完善情况")
    private Long infoCompleteState;

    @ApiModelProperty("用户是否已完成新手引导,返回1则表示已完成")
    private Byte newbieGuideFlag;

    @ApiModelProperty("用户微信号")
    private String wechatId;

    @ApiModelProperty("是否是vip：0-不是 1-是")
    private Integer isVip;

    @ApiModelProperty("激活码剩余使用次数")
    private Integer leftActiveNum;

    @ApiModelProperty("用户收徒总数")
    private Integer inviteNum;

    @ApiModelProperty("用户绑定的商户ID")
    private Long merchantId;

    @ApiModelProperty("标志位")
    private Long judgeMarker;

    @ApiModelProperty(value = "评论数")
    private Integer replyNum;
}
