/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.dto;

import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import lombok.Data;

/**
 * @author : jieli.xu
 * @date 2020/7/13 13:45
 * 用户邀请关系绑定DTO
 */
@Data
public class UserInviteBindDTO {
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 师傅ID-不可为空
     */
    private Long inviteUserId;

    /**
     * 激活码是否还有激活次数：
     * inviteBindMethodEnum = ACTIVE_CODE 时必传
     */
    private Boolean activeCodeHasTime = false;
    /**
     * 邀请关系绑定的帖子/新闻 ID
     */
    private Long relationId;
    /**
     * 邀请关系绑定的帖子/新闻 内容
     */
    private String relationTitle;
    /**
     * 邀请方式
     */
    private InviteBindMethodEnum inviteBindMethodEnum;
    /**
     * 不同场景可能需要更新，可能不需要更新 邀请关系
     * 如果true，代表需要更新,默认不需要，具体的场景需要实现
     */
    private Boolean needUpdate=false;

    /**
     * 是否是支付回调
     * inviteBindMethodEnum = WELFARE_VIP 时必传
     * 默认是false
     */
    private Boolean isCallback = false;
    /**
     * 之前是否已经存在邀请关系，如果存在，那么userInviteHistoryBean肯定不为空
     */
    private Boolean alreadyHas;

    /**
     * 最终保存入库的用户邀请关系：和数据库对应
     */
    private UserInviteHistoryBean userInviteHistoryBean;

    /**
     *  用户信息
     */
    private User user;
}
