package com.bxm.localnews.user.vo;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户实体")
@Data
public class User extends BasicParam {

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户密码")
    private String password;

    @ApiModelProperty("用户手机号码")
    private String phone;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty(hidden = true)
    private int age;

    @ApiModelProperty("用户性别：0:未知; 1:男; 2:女")
    private Byte sex;

    @ApiModelProperty(hidden = true)
    private Byte level;

    @ApiModelProperty(hidden = true)
    private String weixin;

    @ApiModelProperty(hidden = true)
    private String qq;

    @ApiModelProperty(hidden = true)
    private String weibo;

    @ApiModelProperty(hidden = true)
    private Byte state;

    @ApiModelProperty("用户访问凭证")
    private String token;

    @ApiModelProperty(hidden = true)
    private Long expiretime;

    @ApiModelProperty("刷新token")
    private String refreshtoken;

    @ApiModelProperty(hidden = true)
    private Long channelId;

    @ApiModelProperty("是否新用户(首次注册)")
    private Byte isNew;

    @ApiModelProperty(hidden = true)
    private String registerClient;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty(hidden = true)
    private Date createTime;

    @ApiModelProperty(hidden = true)
    private Date updateTime;

    @ApiModelProperty(hidden = true)
    private String channelName;

    @ApiModelProperty(hidden = true)
    private String levelStr;

    @ApiModelProperty("生日(精确到日) [注册不需传]")
    private Date birthday;

    @ApiModelProperty("用户个人信息地址 [注册不需传]")
    private String address;

    @ApiModelProperty("用户注册时的请求IP [注册不需传]")
    private String regIp;

    @ApiModelProperty("用户最后登录时的IP [注册不需传]")
    private String lastLoginIp;

    @ApiModelProperty("定位区域编码 [注册不需传]")
    private String locationCode;

    @ApiModelProperty("定位区域名称 [注册不需传默认为北京]")
    private String locationName;

    @ApiModelProperty(value = "用户是否使用的临时昵称", hidden = true)
    private Byte isTempNickName;

    @ApiModelProperty(value = "用户是否使用的临时头像", hidden = true)
    private Byte isTempHeadImg;

    @ApiModelProperty(value = "是否能够领取新人红包")
    private Byte receiveRedPacket;

    @ApiModelProperty(value = "邀请人id")
    private Long inviteUserId;

    @ApiModelProperty(value = "邀请等级")
    private Integer inviteLevel;

    @ApiModelProperty(value = "注册来源")
    private String registerChannel;

    @ApiModelProperty(value = "用户是否是风险用户 0:否 1：是")
    private Byte risk;

    @ApiModelProperty(value = "发帖数")
    private Integer postNum = 0;

    @ApiModelProperty(value = "评论数")
    private Integer replyNum = 0;

    @ApiModelProperty(value = "注册关联id")
    private Long relationId;

    @ApiModelProperty(hidden = true)
    private Date lastLoginTime;

    @ApiModelProperty("手机型号")
    private String phoneModel;

    @ApiModelProperty("设备号")
    private String equipment;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty(value = "关注数量")
    private Integer attentionNum;

    @ApiModelProperty(value = "粉丝")
    private Integer fanNum;

    @ApiModelProperty(value = "点赞数")
    private Integer likeNum;

    @ApiModelProperty(value = "个人主页背景图")
    private String backgroundImgUrl;

    @ApiModelProperty(value = "家乡地区编码")
    private String hometownCode;

    @ApiModelProperty(value = "家乡名称")
    private String hometownName;

    @ApiModelProperty(value = "情感状态 0：保密  1：单身  2：恋爱中  3：已婚")
    private Byte relationshipStatus;

    @ApiModelProperty("行业一级id")
    private Integer jobType;

    @ApiModelProperty("行业一级名称")
    private String jobTypeName;

    @ApiModelProperty("行业二级名称")
    private String jobCategoryName;

    @ApiModelProperty("行业二级id")
    private Integer jobCategory;

    @ApiModelProperty("公司")
    private String company;

    @ApiModelProperty("职业")
    private String jobTitle;

    @ApiModelProperty("用户资料完善情况")
    private Long infoCompleteState;

    @ApiModelProperty("用户微信号")
    private String wechatId;

    @ApiModelProperty("用户是否已完成新手引导,返回true则表示已完成")
    private Byte newbieGuideFlag;

    /**
     * 3.2.0版本新增字段
     */
    @ApiModelProperty("淘宝客relation_id")
    private String tbkRelationId;

    @ApiModelProperty("淘宝客special_id")
    private String tbkSpecialId;

    @ApiModelProperty("用户邀请人数量")
    private Integer inviteNum;

    @ApiModelProperty("用户绑定的商户ID")
    private Long merchantId;

    @ApiModelProperty("标志位")
    private Long judgeMarker;
}