package com.bxm.localnews.user.vo;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public class UserFollowRecord extends BaseBean implements IUserIdSharding {

    private Long id;

    /**
     * 关注记录所属用户
     */
    private Long userId;

    /**
     * 用户关注的用户ID
     */
    private Long followedUserId;

    /**
     * 关注类型
     * 0:未关注
     * 1：已关注
     * 2：相关关注
     */
    private Byte type;
}