package com.bxm.localnews.user.vo;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;

/**
 * t_user_tag
 * @author 
 */
@Data
@Builder
public class UserTag implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 标签内容
     */
    private String label;

    /**
     * 顺序
     */
    private Integer order;

    /**
     * 所属用户ID
     */
    private Long userId;

    /**
     * 是否删除
     */
    private Byte deleteFlag;

    /**
     * 是否默认
     */
    private Byte defaultFlag;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 创建时间
     */
    private Date createTime;

    private static final long serialVersionUID = 1L;

    public static UserTag buildUserTag(Long userId, Integer order, String label, Long id) {
        return UserTag.builder()
                .userId(userId)
                //顺序号减1，即放在标签列表的最前面
                .order(order)
                .label(label)
                .id(id)
                .deleteFlag((byte) 0)
                .defaultFlag((byte) 0)
                .createTime(new Date()).build();
    }

    @Tolerate
    public UserTag() {

    }

}