package com.bxm.localnews.user.facade;


import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.facade.fallback.InviteRelationFallbackFactory;
import com.bxm.localnews.user.vo.ApprenticeInfoVo;
import com.bxm.localnews.user.vo.ShareMessageVo;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Created by Administrator on 2018/3/3.
 */
@FeignClient(value = "localnews", fallbackFactory = InviteRelationFallbackFactory.class)
public interface InviteRelationFeignService {

    @PostMapping("")
    ResponseEntity<Integer> addInviteRelation(@RequestParam("userId") Long userId, @RequestParam("masterId") Long masterId);

    @GetMapping()
    ResponseEntity<Json> awakeAllPrentices(@RequestParam("userId") Long userId, @RequestParam("remoteAddr") String remoteAddr);

    @PostMapping()
    ResponseEntity<Integer> updateUserAwakenState(@RequestParam("userId") Long userId);

    @GetMapping
    ResponseEntity<Json<ShareMessageVo>> getShareMessage(@RequestParam("userId") Long userId, @RequestParam("shareType") Byte shareType);

    @GetMapping
    ResponseEntity<Json<ApprenticeInfoVo>> getApprenticeInfo(@RequestParam("userId") Long userId, @RequestParam("type") Byte type);
}
