package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.facade.fallback.QuartzManageFallbackFactory;
import com.bxm.localnews.user.param.InviteExpireTaskParam;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-quartz", fallbackFactory = QuartzManageFallbackFactory.class)
public interface QuartzManageFeignService {

    @PostMapping("/quartz/add/invite")
    ResponseEntity<Boolean> createInviteTask(@RequestBody InviteExpireTaskParam param);

    @PostMapping("/quartz/remove/invite")
    ResponseEntity<Boolean> removeInviteTask(@RequestParam("jobId") String jobId);

}

