package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.facade.fallback.UserNewsFallbackFactory;
import com.bxm.localnews.user.vo.User;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-news", fallbackFactory = UserNewsFallbackFactory.class)
public interface UserNewsFeignService {

    @PostMapping("/facade/news/init")
    void initUserImage(@RequestParam("newUserId") Long newUserId, @RequestParam("defaultUserId") Long defaultUserId);

    @PostMapping("/facade/news/sync")
    void syncUser(@RequestBody User user);
}
