package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.facade.QuartzManageFeignService;
import com.bxm.localnews.user.param.InviteExpireTaskParam;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;


@Component
@Slf4j
public class QuartzManageFallbackFactory implements FallbackFactory<QuartzManageFeignService> {
    @Override
    public QuartzManageFeignService create(Throwable throwable) {
        return new QuartzManageFeignService() {

            @Override
            public ResponseEntity<Boolean> createInviteTask(InviteExpireTaskParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Boolean> removeInviteTask(String jobId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

        };
    }
}

