package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.user.facade.UserEventFeignService;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/12 10:55
 * @desc
 */
@Component
@Slf4j
public class UserEventFallbackFactory implements FallbackFactory<UserEventFeignService> {

    @Override
    public UserEventFeignService create(Throwable throwable) {
        return new UserEventFeignService() {
            @Override
            public void addUserEvent(PushPayloadInfo pushPayloadInfo) {
                log.error(throwable.getMessage(), throwable);
            }
        };
    }
}
