package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.facade.UserNewsFeignService;
import com.bxm.localnews.user.vo.User;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserNewsFallbackFactory implements FallbackFactory<UserNewsFeignService> {
    @Override
    public UserNewsFeignService create(Throwable throwable) {
        return new UserNewsFeignService() {
            @Override
            public void initUserImage(Long newUserId, Long defaultUserId) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void syncUser(User user) {
                log.error(throwable.getMessage(), throwable);
            }
        };
    }
}
