package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.facade.VipFeignService;

import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/2/28 18:20
 * @desc
 */
@Component
public class VipFallBackFactory implements FallbackFactory<VipFeignService> {

    @Override
    public VipFeignService create(Throwable throwable) {
        return new VipFeignService() {
            @Override
            public ResponseEntity saveVipViewRecord(Long userId, String unionId) {
                return ResponseEntity.ok(null);
            }

            @Override
            public ResponseEntity<Integer> countVipByUser(Long userId) {
                return ResponseEntity.ok(0);
            }
        };
    }
}
