package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.facade.BizLogFeignService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/2/28 18:09
 * @desc
 */
@Service
public class BizLogIntegrationService {

    @Autowired
    private BizLogFeignService bizLogFeignService;

    public void newUser(Long userId, String channel, String token) {
        bizLogFeignService.newUser(userId, channel, token);
    }

    public void login(Long userId) {
        bizLogFeignService.login(userId);
    }

    public void changeGender(Long userId, int sex) {
        bizLogFeignService.changeGender(userId, sex);
    }

    public void changeArea(Long userId, String areaCode) {
        bizLogFeignService.changeArea(userId, areaCode);
    }

    public void inviteSuccessed(Long userId, Long invitedUserId) {
        bizLogFeignService.inviteSuccessed(userId, invitedUserId);
    }
}
