package com.bxm.localnews.user.integration;


import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.facade.InviteRelationFeignService;
import com.bxm.localnews.user.vo.ApprenticeInfoVo;
import com.bxm.localnews.user.vo.ShareMessageVo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by Administrator on 2018/3/3.
 */
@Service
public class InviteRelationIntegrationService {

    @Autowired
    private InviteRelationFeignService inviteRelationFeignService;

    public int addInviteRelation(Long userId, Long masterId) {
        return inviteRelationFeignService.addInviteRelation(userId, masterId).getBody();
    }


    public Json awakeAllPrentices(Long userId, String remoteAddr) {
        return inviteRelationFeignService.awakeAllPrentices(userId, remoteAddr).getBody();
    }


    public int updateUserAwakenState(Long userId) {
        return inviteRelationFeignService.updateUserAwakenState(userId).getBody();
    }

    public Json<ShareMessageVo> getShareMessage(Long userId, Byte shareType) {
        return inviteRelationFeignService.getShareMessage(userId, shareType).getBody();
    }

    public Json<ApprenticeInfoVo> getApprenticeInfo(Long userId, Byte type) {
        return inviteRelationFeignService.getApprenticeInfo(userId, type).getBody();
    }


}
